#include "iostm8s103f3.h"
#define LCD_CLK   PC_ODR_ODR4//OLEDʱ
#define LCD_MOSI  PC_ODR_ODR3 //OLED
#define LCD_CS    PC_ODR_ODR6 //OLEDƬѡ
#define LCD_DC    PC_ODR_ODR5  //OLED/л
#define XLevelL		0x00
#define XLevelH		0x10
#define XLevel	    ((XLevelH&0x0F)*16+XLevelL)
#define Max_Column	128
#define Max_Row		64
#define	Brightness	0xCF 
#define X_WIDTH 128
#define Y_WIDTH 64

/*********************LCDд************************************/ 
void LCD_WrDat(unsigned char dat)	 
{
unsigned char i;
LCD_DC=1;  
for(i=0;i<8;i++) //һλ 
{
if((dat << i) & 0x80)
{LCD_MOSI  = 1;}
else  LCD_MOSI  = 0;
LCD_CLK = 0;
LCD_CLK = 1;
}
}
/*********************LCDд************************************/										
void LCD_WrCmd(unsigned char cmd)
{
unsigned char i;
LCD_DC=0;
for(i=0;i<8;i++) //һλ 
{
if((cmd << i) & 0x80)
{LCD_MOSI  = 1;}
else  LCD_MOSI  = 0;
LCD_CLK = 0;
LCD_CLK = 1;
}
}
/*********************LCD ************************************/
void LCD_Set_Pos(unsigned char x, unsigned char y) 
{ 
LCD_WrCmd(0xb0+y);
LCD_WrCmd(((x&0xf0)>>4)|0x10);
LCD_WrCmd((x&0x0f)|0x01); 
} 
/*********************LCDȫ************************************/
void LCD_Fill(unsigned char bmp_dat) 
{
unsigned char y,x;
for(y=0;y<8;y++)
{
LCD_WrCmd(0xb0+y);
LCD_WrCmd(0x01);
LCD_WrCmd(0x10);
for(x=0;x<X_WIDTH;x++)
LCD_WrDat(bmp_dat);
}
}
/*********************LCDλ************************************/
void LCD_CLS(void)
{
  unsigned char y,x;	
  for(y=0;y<8;y++)
  {
    LCD_WrCmd(0xb0+y);
    LCD_WrCmd(0x01);
    LCD_WrCmd(0x10); 
    for(x=0;x<X_WIDTH;x++)
    LCD_WrDat(0);
  }
}
/*********************LCDʼ************************************/
void OLED_Init(void)     
{
  DelayMS(500);//ʱҪ
  LCD_CS=0; 
  LCD_WrCmd(0xae);//--turn off oled panel
  LCD_WrCmd(0x00);//---set low column address
  LCD_WrCmd(0x10);//---set high column address
  LCD_WrCmd(0x40);//--set start line address  Set Mapping RAM Display Start Line (0x00~0x3F)
  LCD_WrCmd(0x81);//--set contrast control register
  LCD_WrCmd(0xcf); // Set SEG Output Current Brightness
  LCD_WrCmd(0xa1);//--Set SEG/Column Mapping     0xa0ҷ 0xa1
  LCD_WrCmd(0xc8);//Set COM/Row Scan Direction   0xc0· 0xc8
  LCD_WrCmd(0xa6);//--set normal display
  LCD_WrCmd(0xa8);//--set multiplex ratio(1 to 64)
  LCD_WrCmd(0x3f);//--1/64 duty
  LCD_WrCmd(0xd3);//-set display offset	Shift Mapping RAM Counter (0x00~0x3F)
  LCD_WrCmd(0x00);//-not offset
  LCD_WrCmd(0xd5);//--set display clock divide ratio/oscillator frequency
  LCD_WrCmd(0x80);//--set divide ratio, Set Clock as 100 Frames/Sec
  LCD_WrCmd(0xd9);//--set pre-charge period
  LCD_WrCmd(0xf1);//Set Pre-Charge as 15 Clocks & Discharge as 1 Clock
  LCD_WrCmd(0xda);//--set com pins hardware configuration
  LCD_WrCmd(0x12);
  LCD_WrCmd(0xdb);//--set vcomh
  LCD_WrCmd(0x40);//Set VCOM Deselect Level
  LCD_WrCmd(0x20);//-Set Page Addressing Mode (0x00/0x01/0x02)
  LCD_WrCmd(0x02);//
  LCD_WrCmd(0x8d);//--set Charge Pump enable/disable
  LCD_WrCmd(0x14);//--set(0x10) disable
  LCD_WrCmd(0xa4);// Disable Entire Display On (0xa4/0xa5)
  LCD_WrCmd(0xa6);// Disable Inverse Display On (0xa6/a7) 
  LCD_WrCmd(0xaf);//--turn on oled panel
  LCD_Fill(0x00);  //ʼ
  LCD_Set_Pos(0,0);
} 
/*****************ʾ16*16  ʾ꣨x,yyΪҳΧ07****************************/
void LCD_P16x16Ch(unsigned char x, unsigned char y, unsigned char N)
{
unsigned char wm=0;
unsigned int adder=32*N;  //  	
LCD_Set_Pos(x , y);
for(wm = 0;wm < 16;wm++)  //             
{
LCD_WrDat(F16x16[adder]);	
adder += 1;
}
LCD_Set_Pos(x,y + 1); 
for(wm = 0;wm < 16;wm++) //         
{
LCD_WrDat(F16x16[adder]);
adder += 1;
} 	  	
}

/***********ʾ浥16*24 ʼ(x,y),xķΧ0127yΪҳķΧ07**********/
void WRT_HIGDATA(unsigned char x,unsigned char y,unsigned char txd)
{
 unsigned char i;
  LCD_Set_Pos(x, y);
  for(i=0;i<12;i++)  
 {LCD_WrDat(F16x24[ txd*36+i]); } 
 LCD_Set_Pos(x, y+1);
 for(i=0;i<12;i++) 
 {LCD_WrDat(F16x24[txd*36+i+12]);} 
 LCD_Set_Pos(x, y+2);
  for(i=0;i<12;i++)  
 {LCD_WrDat(F16x24[ txd*36+i+24]); }  
}


/*****************ʾ浥24*24 ʾ꣨x,yyΪҳΧ07****************************/
void WRT_DATA(unsigned char x,unsigned char y,unsigned char txd)
{
  unsigned char i;
  LCD_Set_Pos(x, y);
  for(i=0;i<24;i++)  
 {LCD_WrDat(F24x24[ txd*72+i]); } 
 LCD_Set_Pos(x, y+1);
 for(i=0;i<24;i++) 
 {LCD_WrDat(F24x24[txd*72+i+24]);} 
 LCD_Set_Pos(x, y+2);
  for(i=0;i<24;i++)  
 {LCD_WrDat(F24x24[ txd*72+i+48]); } 
}


/***********ʾ浥8*16 ʼ(x,y),xķΧ0127yΪҳķΧ07**********/
void WRT_LOWDATA(unsigned char x,unsigned char y,unsigned char txd)
{
  unsigned char i;
  LCD_Set_Pos(x, y);
  for(i=0;i<8;i++)  
 {LCD_WrDat(F8X16[ txd*16+i]); } 
 LCD_Set_Pos(x+8, y);
 for(i=0;i<8;i++) 
 {LCD_WrDat(F8X16[txd*16+i+8]);} 
}

